/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.update;

import de.willuhn.jameica.gui.internal.dialogs.PluginSourceDialog;
import de.willuhn.jameica.messaging.TextMessage;
import de.willuhn.jameica.plugin.Manifest;
import de.willuhn.jameica.plugin.PluginSource;
import de.willuhn.jameica.plugin.ZippedPlugin;
import de.willuhn.jameica.services.DeployService;
import de.willuhn.jameica.services.PluginSourceService;
import de.willuhn.jameica.services.RepositoryService;
import de.willuhn.jameica.services.TransportService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.BackgroundTask;
import de.willuhn.jameica.system.ConsoleMonitor;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.jameica.transport.Transport;
import de.willuhn.jameica.update.PluginData;
import de.willuhn.jameica.update.PluginGroup;
import de.willuhn.jameica.util.XPathEmu;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import de.willuhn.util.ProgressMonitor;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLParserFactory;

public class Repository {
    private URL url = null;
    private String name = null;
    private List<PluginGroup> groups = new ArrayList<PluginGroup>();

    public Repository(URL url) throws ApplicationException {
        if (url == null) {
            throw new ApplicationException(Application.getI18n().tr("Keine Repository-URL angegeben"));
        }
        this.url = url;
        try {
            Logger.info((String)("open repository " + this.url));
            Object s = this.url.toString();
            if (!((String)s).endsWith("/")) {
                s = (String)s + "/";
            }
            TransportService service = (TransportService)Application.getBootLoader().getBootable(TransportService.class);
            Transport t = service.getTransport(new URL((String)s + "repository.xml"));
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            t.get(bos, null);
            IXMLParser parser = XMLParserFactory.createDefaultXMLParser();
            parser.setReader((IXMLReader)new StdXMLReader((InputStream)new ByteArrayInputStream(bos.toByteArray())));
            IXMLElement root = (IXMLElement)parser.parse();
            this.name = root.getAttribute("name", null);
            XPathEmu xpath = new XPathEmu(root);
            IXMLElement[] list = xpath.getElements("plugins");
            if (list == null || list.length == 0) {
                Logger.warn((String)("repository " + (String)s + " contains no plugin groups"));
                return;
            }
            for (IXMLElement e : list) {
                try {
                    this.groups.add(new PluginGroup(this, e));
                }
                catch (Exception ex) {
                    Logger.error((String)"unable to load plugin group, skipping", (Throwable)ex);
                }
            }
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (OperationCanceledException oce) {
            throw oce;
        }
        catch (Exception e) {
            Throwable t = e.getCause();
            if (t instanceof OperationCanceledException) {
                throw (OperationCanceledException)t;
            }
            Logger.error((String)("unable to read from url " + this.url), (Throwable)e);
            throw new ApplicationException(Application.getI18n().tr("Repository {0} nicht lesbar: {1}", new String[]{this.url.toString(), e.getMessage()}), (Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    public URL getUrl() {
        return this.url;
    }

    public List<PluginData> getPlugins() {
        ArrayList<PluginData> list = new ArrayList<PluginData>();
        for (PluginGroup group : this.getPluginGroups()) {
            list.addAll(group.getPlugins());
        }
        return list;
    }

    public List<PluginGroup> getPluginGroups() {
        return this.groups;
    }

    public void download(final PluginData data, final boolean interactive) throws ApplicationException {
        final I18N i18n = Application.getI18n();
        BackgroundTask t = new BackgroundTask(){

            @Override
            public void run(ProgressMonitor monitor) throws ApplicationException {
                String name = data.getName();
                File dir = Application.getConfig().getUpdateDir();
                File archive = null;
                File sig = null;
                Transport t = null;
                boolean sigchecked = false;
                boolean update = false;
                try {
                    Logger.info((String)("checking if plugin " + name + " is signed"));
                    TransportService ts = (TransportService)Application.getBootLoader().getBootable(TransportService.class);
                    t = ts.getTransport(data.getSignatureUrl());
                    if (t.exists()) {
                        sig = new File(dir, name + ".zip.sha1");
                        t.get(new BufferedOutputStream(new FileOutputStream(sig)), null);
                        Logger.info((String)("created signature file " + sig));
                    } else if (interactive) {
                        String q = i18n.tr("Das Plugin \"{0}\" wurde vom Herausgeber nicht signiert.\nM\u00f6chten Sie es dennoch installieren?", name);
                        if (!Application.getCallback().askUser(q, false)) {
                            throw new OperationCanceledException(i18n.tr("Vorgang abgebrochen"));
                        }
                    }
                    t = ts.getTransport(data.getDownloadUrl());
                    archive = new File(dir, name + ".zip");
                    Logger.info((String)("creating deploy file " + archive));
                    t.get(new BufferedOutputStream(new FileOutputStream(archive)), monitor);
                    if (sig != null) {
                        RepositoryService service = (RepositoryService)Application.getBootLoader().getBootable(RepositoryService.class);
                        service.checkSignature(data, archive, sig);
                        sigchecked = true;
                    }
                    ZippedPlugin zp = new ZippedPlugin(archive);
                    DeployService service = (DeployService)Application.getBootLoader().getBootable(DeployService.class);
                    Manifest mf = zp.getManifest();
                    Manifest installed = Application.getPluginLoader().getManifestByName(mf.getName());
                    if (installed != null) {
                        service.update(installed, zp, monitor);
                        update = true;
                    } else {
                        PluginSource source = Application.inServerMode() ? null : Repository.this.getPluginSource(mf);
                        service.deploy(zp, source, monitor);
                    }
                    if (interactive) {
                        Object text = sigchecked ? i18n.tr("Digitale Signatur des Plugins \"{0}\" korrekt.", name) : i18n.tr("Plugin \"{0}\" enthielt keine digitale Signatur.", name);
                        text = (String)text + "\n" + i18n.tr("Die Installation erfolgt beim n\u00e4chsten Neustart von Jameica.");
                        TextMessage msg = new TextMessage(i18n.tr("Plugin \"{0}\" heruntergeladen", name), (String)text);
                        Application.getMessagingFactory().getMessagingQueue("jameica.popup").sendMessage(msg);
                    }
                }
                catch (Exception e) {
                    if (e instanceof ApplicationException) {
                        throw (ApplicationException)((Object)e);
                    }
                    if (e instanceof OperationCanceledException) {
                        throw new ApplicationException(e.getMessage());
                    }
                    Logger.error((String)"error while downloading file", (Throwable)e);
                    throw new ApplicationException(i18n.tr("Fehler beim Herunterladen des Plugins \"{0}\": {1}", new String[]{name, e.getMessage()}));
                }
                finally {
                    if (!update && archive != null && archive.exists()) {
                        Logger.info((String)("deleting " + archive));
                        archive.delete();
                    }
                    if (sig != null && sig.exists()) {
                        Logger.info((String)("delete signature " + sig));
                        sig.delete();
                    }
                }
            }

            @Override
            public boolean isInterrupted() {
                return false;
            }

            @Override
            public void interrupt() {
            }
        };
        if (interactive) {
            Application.getController().start(t);
        } else {
            t.run(new ConsoleMonitor());
        }
    }

    private PluginSource getPluginSource(Manifest mf) throws Exception {
        PluginSourceService service = (PluginSourceService)Application.getBootLoader().getBootable(PluginSourceService.class);
        List<PluginSource> sources = service.getWritableSources();
        if (sources.size() == 1) {
            return sources.get(0);
        }
        if (sources.size() > 1) {
            PluginSourceDialog psd = new PluginSourceDialog(1, mf);
            return (PluginSource)psd.open();
        }
        return null;
    }
}

